//
//  CheckPendingPushViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit
import FirebaseMessaging

class CheckPendingPushViewController: BaseViewController {

    @IBOutlet weak var pushContainer: UIView!
    @IBOutlet weak var aliasText: UILabel!
    @IBOutlet weak var actionText: UILabel!
    @IBOutlet weak var contextText: UILabel!
    
    var checkImmediately = false
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "Check Pending push"
        pushContainer.isHidden = true
        print("FCM Token: \(Messaging.messaging().fcmToken ?? "")")
        
        if checkImmediately {
            checkPendingPush()
        }
        
        NotificationCenter.default.addObserver(self, selector: #selector(notificationReceived(notification:)), name: Notification.Name("notification"), object: nil)
    }
    
    // MARK: Notifications
    @objc
    func notificationReceived(notification: Notification?) {
        checkPendingPush()
    }
    
    func registerFirebase(token: String) {
        InweboService.sharedInstance.setDeviceOS(os: "firebase")
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startPushRegistration()
            if result == IW_ERR_OK {
                let result2 = InweboService.sharedInstance.finalizePushRegistration(token: token)
                DispatchQueue.main.async {
                    if result2 == IW_ERR_OK {
                        self.showAlert(title: "Push registration", message: "Push successfully registered")
                    } else {
                        self.showErrorFor(code: result)
                    }
                }
            } else {
                DispatchQueue.main.async {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    func checkPendingPush() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.checkPush()
            if result == IW_ERR_OK {
                let alias = InweboService.sharedInstance.getPushAlias()
                let action = InweboService.sharedInstance.getPushAction()
                let context = InweboService.sharedInstance.getPushContext()
                
                DispatchQueue.main.async {
                    self.aliasText.text = alias
                    self.actionText.text = action
                    self.contextText.text = context
                    self.pushContainer.isHidden = false
                    
                    if let action = action, let alias = alias, action.elementsEqual("authenticate") {
                        self.showPushOTPAuthentication(service: nil, alias: alias)
                    }
                }
                return
            }
            
            DispatchQueue.main.async {
                if result == IW_ERR_OTHER {
                    self.showAlert(title: "Pending Push", message: "No pending push available or mobile push service may not be activated")
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    @IBAction func registerTouched(_ sender: Any) {
        if let appDelegate = UIApplication.shared.delegate as? AppDelegate {
            appDelegate.registerNotification { token in
                self.registerFirebase(token: token)
            }
        }
    }

    @IBAction func checkTouched(_ sender: Any) {
        self.checkPendingPush()
    }
}
